-- MySQL Administrator dump 1.4
--
-- ------------------------------------------------------
-- Server version	5.7.18-log


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;




--
-- Definition of table `catalog`
--

DROP TABLE IF EXISTS `catalog`;
CREATE TABLE `catalog` (
  `idcatalog` int(11) NOT NULL AUTO_INCREMENT,
  `super_catalog_idsuper_catalog` int(11) NOT NULL,
  `language` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `catalog_num` int(11) NOT NULL,
  `catalog_code` varchar(60) COLLATE utf8_unicode_ci NOT NULL,
  `description` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `group_num` int(11) DEFAULT NULL,
  PRIMARY KEY (`idcatalog`),
  KEY `fk_catalog_super_catalog1_idx` (`super_catalog_idsuper_catalog`),
  KEY `idx1_catalog` (`super_catalog_idsuper_catalog`,`catalog_num`),
  KEY `idx2_catalog` (`super_catalog_idsuper_catalog`,`catalog_code`),
  KEY `idx3_catalog` (`group_num`,`super_catalog_idsuper_catalog`),
  CONSTRAINT `fk_catalog_super_catalog1` FOREIGN KEY (`super_catalog_idsuper_catalog`) REFERENCES `super_catalog` (`idsuper_catalog`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=56 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `catalog`
--

/*!40000 ALTER TABLE `catalog` DISABLE KEYS */;
INSERT INTO `catalog` (`idcatalog`,`super_catalog_idsuper_catalog`,`language`,`catalog_num`,`catalog_code`,`description`,`group_num`) VALUES 
 (1,1,'',0,'English','Inglés',NULL),
 (2,1,'',1,'Spanish','Español',NULL),
 (3,2,'English',0,'Public','Pública',NULL),
 (4,2,'English',1,'Private','Privada',NULL),
 (5,2,'Spanish',0,'Pública','',NULL),
 (6,2,'Spanish',1,'Privada','',NULL),
 (7,3,'English',0,'Not','no',NULL),
 (8,3,'English',1,'Yes','sí',NULL),
 (9,3,'Spanish',0,'No','',NULL),
 (10,3,'Spanish',1,'Sí','',NULL),
 (19,5,'English',0,'Planning','Planificación',NULL),
 (20,5,'English',1,'Production','En Producción',NULL),
 (21,5,'English',2,'Finished','Terminado',NULL),
 (22,5,'Spanish',0,'Planificación','',NULL),
 (23,5,'Spanish',1,'Producción','',NULL),
 (24,5,'Spanish',2,'Terminado','',NULL),
 (25,7,'English',0,'Days','',NULL),
 (26,7,'English',1,'Hours','',NULL),
 (27,7,'Spanish',0,'Días','',NULL),
 (28,7,'Spanish',1,'Horas','',NULL),
 (29,8,'',0,'0 %','',NULL),
 (30,8,'',10,'10 %','',NULL),
 (31,8,'',20,'20 %','',NULL),
 (32,8,'',30,'30 %','',NULL),
 (33,8,'',40,'40 %','',NULL),
 (34,8,'',50,'50 %','',NULL),
 (35,8,'',60,'60 %','',NULL),
 (36,8,'',70,'70 %','',NULL),
 (37,8,'',80,'80 %','',NULL),
 (38,8,'',90,'90 %','',NULL),
 (39,8,'',100,'100 %','',NULL),
 (40,4,'English',0,'Owner','Owner of Meeting',NULL),
 (41,4,'English',1,'Necessary','',NULL),
 (42,4,'English',2,'Optional','',NULL),
 (43,4,'English',3,'Manage Resources','',NULL),
 (44,4,'English',4,'Informed','',NULL),
 (45,4,'Spanish',0,'Propietario','Propietario de la Reunión',NULL),
 (46,4,'Spanish',1,'Necesario','',NULL),
 (47,4,'Spanish',2,'Opcional','',NULL),
 (48,4,'Spanish',3,'Gestor de los recursos','',NULL),
 (49,4,'Spanish',4,'Informado','',NULL),
 (50,9,'English',0,'Pending','',NULL),
 (51,9,'English',1,'Accepted','',NULL),
 (52,9,'English',2,'Rejected','',NULL),
 (53,9,'Spanish',0,'Pendiente','',NULL),
 (54,9,'Spanish',1,'Aceptada','',NULL),
 (55,9,'Spanish',2,'Rechazada','',NULL);
/*!40000 ALTER TABLE `catalog` ENABLE KEYS */;


--
-- Definition of table `companies`
--

DROP TABLE IF EXISTS `companies`;
CREATE TABLE `companies` (
  `company_id` int(10) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `phone1` varchar(30) COLLATE utf8_unicode_ci DEFAULT '',
  `fax` varchar(30) COLLATE utf8_unicode_ci DEFAULT '',
  `address1` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `address2` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `city` varchar(30) COLLATE utf8_unicode_ci DEFAULT '',
  `state` varchar(30) COLLATE utf8_unicode_ci DEFAULT '',
  `zip` varchar(11) COLLATE utf8_unicode_ci DEFAULT '',
  `country` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `primary_url` varchar(255) COLLATE utf8_unicode_ci DEFAULT '',
  `owner` int(10) NOT NULL DEFAULT '0',
  `description` mediumtext COLLATE utf8_unicode_ci,
  `email` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `private` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`company_id`),
  KEY `company_name` (`name`),
  KEY `company_owner` (`owner`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `companies`
--

/*!40000 ALTER TABLE `companies` DISABLE KEYS */;
INSERT INTO `companies` (`company_id`,`name`,`phone1`,`fax`,`address1`,`address2`,`city`,`state`,`zip`,`country`,`primary_url`,`owner`,`description`,`email`,`private`) VALUES 
 (0,'Administración','','','','','','','','','',6,'','info@fhumanes.com',1),
 (3,'Compañía 1','','','','','','','','','',6,'','info@fhumanes.com',0);
/*!40000 ALTER TABLE `companies` ENABLE KEYS */;


--
-- Definition of table `config`
--

DROP TABLE IF EXISTS `config`;
CREATE TABLE `config` (
  `config_id` int(10) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `value` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `group` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `type` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`config_id`),
  UNIQUE KEY `config_name` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `config`
--

/*!40000 ALTER TABLE `config` DISABLE KEYS */;
INSERT INTO `config` (`config_id`,`name`,`value`,`group`,`type`) VALUES 
 (1,'URL','http://localhost/meetings','',''),
 (3,'PLUGIN_ICON','mis_imagenes/','',''),
 (6,'FOLDER_FILES','files','','');
/*!40000 ALTER TABLE `config` ENABLE KEYS */;


--
-- Definition of table `departments`
--

DROP TABLE IF EXISTS `departments`;
CREATE TABLE `departments` (
  `dept_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `companies_company_id` int(10) NOT NULL,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `phone` varchar(30) COLLATE utf8_unicode_ci DEFAULT NULL,
  `fax` varchar(30) COLLATE utf8_unicode_ci DEFAULT NULL,
  `desc` mediumtext COLLATE utf8_unicode_ci,
  `email` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`dept_id`),
  KEY `dept_name` (`name`),
  KEY `fk_departments_companies1_idx` (`companies_company_id`),
  CONSTRAINT `fk_departments_companies1` FOREIGN KEY (`companies_company_id`) REFERENCES `companies` (`company_id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='Department heirarchy under a company';

--
-- Dumping data for table `departments`
--

/*!40000 ALTER TABLE `departments` DISABLE KEYS */;
INSERT INTO `departments` (`dept_id`,`companies_company_id`,`name`,`phone`,`fax`,`desc`,`email`) VALUES 
 (1,3,'Departament 1','','','','info@fhumanes.com');
/*!40000 ALTER TABLE `departments` ENABLE KEYS */;


--
-- Definition of table `files_meetings`
--

DROP TABLE IF EXISTS `files_meetings`;
CREATE TABLE `files_meetings` (
  `idfiles_meetings` int(11) NOT NULL AUTO_INCREMENT,
  `meetings_idmeetings` int(11) NOT NULL,
  `description` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `files_content` varchar(500) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`idfiles_meetings`),
  KEY `fk_files_meetings_meetings1_idx` (`meetings_idmeetings`),
  CONSTRAINT `fk_files_meetings_meetings1` FOREIGN KEY (`meetings_idmeetings`) REFERENCES `meetings` (`idmeetings`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `files_meetings`
--

/*!40000 ALTER TABLE `files_meetings` DISABLE KEYS */;
INSERT INTO `files_meetings` (`idfiles_meetings`,`meetings_idmeetings`,`description`,`files_content`) VALUES 
 (1,1,'Pruebas','[{\"name\":\"files\\/meetings_002_udv9o5r8.png\",\"usrName\":\"meetings_002.png\",\"size\":705043,\"type\":\"image\\/png\",\"searchStr\":\"meetings_002.png,!:sStrEnd\"}]');
/*!40000 ALTER TABLE `files_meetings` ENABLE KEYS */;


--
-- Definition of table `meetings`
--

DROP TABLE IF EXISTS `meetings`;
CREATE TABLE `meetings` (
  `idmeetings` int(11) NOT NULL AUTO_INCREMENT,
  `projects_project_id` int(10) NOT NULL,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `owner` int(11) NOT NULL,
  `start_date` datetime NOT NULL,
  `end_date` datetime NOT NULL,
  `description` mediumtext COLLATE utf8_unicode_ci NOT NULL,
  `created` datetime NOT NULL,
  `updated` datetime DEFAULT NULL,
  `creator` int(11) NOT NULL,
  `modifier` int(11) DEFAULT NULL,
  PRIMARY KEY (`idmeetings`),
  KEY `fk_meetings_projects1_idx` (`projects_project_id`),
  CONSTRAINT `fk_meetings_projects1` FOREIGN KEY (`projects_project_id`) REFERENCES `projects` (`project_id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `meetings`
--

/*!40000 ALTER TABLE `meetings` DISABLE KEYS */;
INSERT INTO `meetings` (`idmeetings`,`projects_project_id`,`name`,`owner`,`start_date`,`end_date`,`description`,`created`,`updated`,`creator`,`modifier`) VALUES 
 (1,2,'Meeting 1 \"esto es una excepción\"',6,'2020-05-04 12:00:00','2020-05-04 13:00:00','<div>informe.</div><div><ol><li>Paso 1</li><li>Paso 2<br></li></ol></div><div id=\"SL_balloon_obj\" alt=\"0\" style=\"display: block;\"><div id=\"SL_button\" class=\"SL_ImTranslatorLogo\" style=\"background: rgba(0, 0, 0, 0) url(\" moz-extension:=\"\" 3a6e0bcb-7eac-40ca-8c9f-c9aa18168b9b=\"\" content=\"\" img=\"\" util=\"\" imtranslator-s.png\")=\"\" repeat=\"\" scroll=\"\" 0%=\"\" 0%;=\"\" display:=\"\" none;=\"\" opacity:=\"\" 1;\"=\"\"></div><div id=\"SL_shadow_translation_result2\" style=\"display: none;\"></div><div id=\"SL_shadow_translator\" style=\"left: 0px; top: 9px; display: none;\"><div id=\"SL_planshet\"><div id=\"SL_arrow_up\" style=\"background: rgba(0, 0, 0, 0) url(\" moz-extension:=\"\" 3a6e0bcb-7eac-40ca-8c9f-c9aa18168b9b=\"\" content=\"\" img=\"\" util=\"\" up.png\")=\"\" repeat=\"\" scroll=\"\" 0%=\"\" 0%;=\"\" display:=\"\" none;\"=\"\"></div><div id=\"SL_Bproviders\"></div><div id=\"SL_alert_bbl\" style=\"display: none;\"><div id=\"SLHKclose\" style=\"background: rgba(0, 0, 0, 0) url(\" moz-extension:=\"\" 3a6e0bcb-7eac-40ca-8c9f-c9aa18168b9b=\"\" content=\"\" img=\"\" util=\"\" delete.png\")=\"\" repeat=\"\" scroll=\"\" 0%=\"\" 0%;\"=\"\"></div><div id=\"SL_alert_cont\"></div></div><div id=\"SL_TB\"><table id=\"SL_tables\" cellspacing=\"1\"><tbody><tr><td class=\"SL_td\" width=\"10%\" align=\"right\"><input id=\"SL_locer\" type=\"checkbox\" title=\"Fijar idioma\"></td><td class=\"SL_td\" width=\"20%\" align=\"left\"><select id=\"SL_lng_from\" class=\"SL_lngs\" style=\"background: rgb(255, 255, 255) url(\" moz-extension:=\"\" 3a6e0bcb-7eac-40ca-8c9f-c9aa18168b9b=\"\" content=\"\" img=\"\" util=\"\" select.png\")=\"\" no-repeat=\"\" scroll=\"\" 100%=\"\" 0px;\"=\"\"><option value=\"auto\">Detectar idioma</option><option value=\"af\">Afrikáans</option><option value=\"sq\">Albanés</option><option value=\"de\">Alemán</option><option value=\"am\">Amhárico</option><option value=\"ar\">Árabe</option><option value=\"hy\">Armenio</option><option value=\"az\">Azerí</option><option value=\"bn\">Bengalí</option><option value=\"be\">Bielorruso</option><option value=\"my\">Birmano</option><option value=\"bs\">Bosnio</option><option value=\"bg\">Búlgaro</option><option value=\"km\">Camboyano</option><option value=\"kn\">Canarés</option><option value=\"ca\">Catalán</option><option value=\"ceb\">Cebuano</option><option value=\"cs\">Checo</option><option value=\"ny\">Chichewa</option><option value=\"zh-CN\">Chino simp</option><option value=\"zh-TW\">Chino trad</option><option value=\"si\">Cincalés</option><option value=\"ko\">Coreano</option><option value=\"co\">Corso</option><option value=\"ht\">Criollo haitiano</option><option value=\"hr\">Croata</option><option value=\"da\">Danés</option><option value=\"sk\">Eslovaco</option><option value=\"sl\">Esloveno</option><option value=\"es\">Español</option><option value=\"eo\">Esperanto</option><option value=\"et\">Estonio</option><option value=\"eu\">Euskera</option><option value=\"fi\">Finlandés</option><option value=\"fr\">Francés</option><option value=\"fy\">Frisio</option><option value=\"gd\">Gaélico escocés</option><option value=\"cy\">Galés</option><option value=\"gl\">Gallego</option><option value=\"ka\">Georgiano</option><option value=\"el\">Griego</option><option value=\"gu\">Gujarati</option><option value=\"ha\">Hausa</option><option value=\"haw\">Hawaiano</option><option value=\"iw\">Hebreo</option><option value=\"hi\">Hindi</option><option value=\"hmn\">Hmong</option><option value=\"nl\">Holandés</option><option value=\"hu\">Húngaro</option><option value=\"ig\">Igbo</option><option value=\"id\">Indonesio</option><option value=\"en\">Inglés</option><option value=\"ga\">Irlandés</option><option value=\"is\">Islandés</option><option value=\"it\">Italiano</option><option value=\"ja\">Japonés</option><option value=\"jw\">Javanés</option><option value=\"kk\">Kazajo</option><option value=\"ky\">Kirguís</option><option value=\"ku\">Kurdo</option><option value=\"lo\">Lao</option><option value=\"la\">Latín</option><option value=\"lv\">Letón</option><option value=\"lt\">Lituano</option><option value=\"lb\">Luxemburgués</option><option value=\"mk\">Macedonio</option><option value=\"ml\">Malayalam</option><option value=\"ms\">Malayo</option><option value=\"mg\">Malgache</option><option value=\"mt\">Maltés</option><option value=\"mi\">Maorí</option><option value=\"mr\">Maratí</option><option value=\"mn\">Mongol</option><option value=\"ne\">Nepalí</option><option value=\"no\">Noruego</option><option value=\"pa\">Panyabí</option><option value=\"ps\">Pastún</option><option value=\"fa\">Persa</option><option value=\"pl\">Polaco</option><option value=\"pt\">Portugués</option><option value=\"ro\">Rumano</option><option value=\"ru\">Ruso</option><option value=\"sm\">Samoano</option><option value=\"sr\">Serbio</option><option value=\"st\">Sesoto</option><option value=\"sn\">Shona</option><option value=\"sd\">Sindhi</option><option value=\"so\">Somalí</option><option value=\"sw\">Suajili</option><option value=\"sv\">Sueco</option><option value=\"su\">Sundanés</option><option value=\"tl\">Tagalo</option><option value=\"th\">Tailandés</option><option value=\"ta\">Tamil</option><option value=\"tg\">Tayiko</option><option value=\"te\">Telugu</option><option value=\"tr\">Turco</option><option value=\"uk\">Ucraniano</option><option value=\"ur\">Urdu</option><option value=\"uz\">Uzbeco</option><option value=\"vi\">Vietnamita</option><option value=\"xh\">Xhosa</option><option value=\"yi\">Yidis</option><option value=\"yo\">Yoruba</option><option value=\"zu\">Zulú</option></select></td><td class=\"SL_td\" width=\"3\" align=\"center\"><div id=\"SL_switch_b\" title=\"Cambiar idiomas\" style=\"background: rgba(0, 0, 0, 0) url(\" moz-extension:=\"\" 3a6e0bcb-7eac-40ca-8c9f-c9aa18168b9b=\"\" content=\"\" img=\"\" util=\"\" switchb.png\")=\"\" repeat=\"\" scroll=\"\" 0%=\"\" 0%;\"=\"\"></div></td><td class=\"SL_td\" width=\"20%\" align=\"left\"><select id=\"SL_lng_to\" class=\"SL_lngs\" style=\"background: rgb(255, 255, 255) url(\" moz-extension:=\"\" 3a6e0bcb-7eac-40ca-8c9f-c9aa18168b9b=\"\" content=\"\" img=\"\" util=\"\" select.png\")=\"\" no-repeat=\"\" scroll=\"\" 100%=\"\" 0px;\"=\"\"><option value=\"af\">Afrikáans</option><option value=\"sq\">Albanés</option><option value=\"de\">Alemán</option><option value=\"am\">Amhárico</option><option value=\"ar\">Árabe</option><option value=\"hy\">Armenio</option><option value=\"az\">Azerí</option><option value=\"bn\">Bengalí</option><option value=\"be\">Bielorruso</option><option value=\"my\">Birmano</option><option value=\"bs\">Bosnio</option><option value=\"bg\">Búlgaro</option><option value=\"km\">Camboyano</option><option value=\"kn\">Canarés</option><option value=\"ca\">Catalán</option><option value=\"ceb\">Cebuano</option><option value=\"cs\">Checo</option><option value=\"ny\">Chichewa</option><option value=\"zh-CN\">Chino simp</option><option value=\"zh-TW\">Chino trad</option><option value=\"si\">Cincalés</option><option value=\"ko\">Coreano</option><option value=\"co\">Corso</option><option value=\"ht\">Criollo haitiano</option><option value=\"hr\">Croata</option><option value=\"da\">Danés</option><option value=\"sk\">Eslovaco</option><option value=\"sl\">Esloveno</option><option selected=\"selected\" value=\"es\">Español</option><option value=\"eo\">Esperanto</option><option value=\"et\">Estonio</option><option value=\"eu\">Euskera</option><option value=\"fi\">Finlandés</option><option value=\"fr\">Francés</option><option value=\"fy\">Frisio</option><option value=\"gd\">Gaélico escocés</option><option value=\"cy\">Galés</option><option value=\"gl\">Gallego</option><option value=\"ka\">Georgiano</option><option value=\"el\">Griego</option><option value=\"gu\">Gujarati</option><option value=\"ha\">Hausa</option><option value=\"haw\">Hawaiano</option><option value=\"iw\">Hebreo</option><option value=\"hi\">Hindi</option><option value=\"hmn\">Hmong</option><option value=\"nl\">Holandés</option><option value=\"hu\">Húngaro</option><option value=\"ig\">Igbo</option><option value=\"id\">Indonesio</option><option value=\"en\">Inglés</option><option value=\"ga\">Irlandés</option><option value=\"is\">Islandés</option><option value=\"it\">Italiano</option><option value=\"ja\">Japonés</option><option value=\"jw\">Javanés</option><option value=\"kk\">Kazajo</option><option value=\"ky\">Kirguís</option><option value=\"ku\">Kurdo</option><option value=\"lo\">Lao</option><option value=\"la\">Latín</option><option value=\"lv\">Letón</option><option value=\"lt\">Lituano</option><option value=\"lb\">Luxemburgués</option><option value=\"mk\">Macedonio</option><option value=\"ml\">Malayalam</option><option value=\"ms\">Malayo</option><option value=\"mg\">Malgache</option><option value=\"mt\">Maltés</option><option value=\"mi\">Maorí</option><option value=\"mr\">Maratí</option><option value=\"mn\">Mongol</option><option value=\"ne\">Nepalí</option><option value=\"no\">Noruego</option><option value=\"pa\">Panyabí</option><option value=\"ps\">Pastún</option><option value=\"fa\">Persa</option><option value=\"pl\">Polaco</option><option value=\"pt\">Portugués</option><option value=\"ro\">Rumano</option><option value=\"ru\">Ruso</option><option value=\"sm\">Samoano</option><option value=\"sr\">Serbio</option><option value=\"st\">Sesoto</option><option value=\"sn\">Shona</option><option value=\"sd\">Sindhi</option><option value=\"so\">Somalí</option><option value=\"sw\">Suajili</option><option value=\"sv\">Sueco</option><option value=\"su\">Sundanés</option><option value=\"tl\">Tagalo</option><option value=\"th\">Tailandés</option><option value=\"ta\">Tamil</option><option value=\"tg\">Tayiko</option><option value=\"te\">Telugu</option><option value=\"tr\">Turco</option><option value=\"uk\">Ucraniano</option><option value=\"ur\">Urdu</option><option value=\"uz\">Uzbeco</option><option value=\"vi\">Vietnamita</option><option value=\"xh\">Xhosa</option><option value=\"yi\">Yidis</option><option value=\"yo\">Yoruba</option><option value=\"zu\">Zulú</option></select></td><td class=\"SL_td\" width=\"8%\" align=\"center\"><div id=\"SL_TTS_voice\" title=\"undefined\" style=\"background: rgba(0, 0, 0, 0) url(\" moz-extension:=\"\" 3a6e0bcb-7eac-40ca-8c9f-c9aa18168b9b=\"\" content=\"\" img=\"\" util=\"\" ttsvoice.png\")=\"\" repeat=\"\" scroll=\"\" 0%=\"\" 0%;\"=\"\"></div></td><td class=\"SL_td\" width=\"8%\" align=\"center\"><div id=\"SL_copy\" title=\"Copiar\" class=\"SL_copy\" style=\"background: rgba(0, 0, 0, 0) url(\" moz-extension:=\"\" 3a6e0bcb-7eac-40ca-8c9f-c9aa18168b9b=\"\" content=\"\" img=\"\" util=\"\" copy.png\")=\"\" repeat=\"\" scroll=\"\" 0%=\"\" 0%;\"=\"\"><div id=\"SL_copy_tip\"></div></div></td><td class=\"SL_td\" width=\"8%\" align=\"center\"><div id=\"SL_bbl_font_patch\"></div><div id=\"SL_bbl_font\" title=\"Тamaño de fuente\" class=\"SL_bbl_font\" style=\"background: rgba(0, 0, 0, 0) url(\" moz-extension:=\"\" 3a6e0bcb-7eac-40ca-8c9f-c9aa18168b9b=\"\" content=\"\" img=\"\" util=\"\" font.png\")=\"\" repeat=\"\" scroll=\"\" 0%=\"\" 0%;\"=\"\"></div></td><td class=\"SL_td\" width=\"8%\" align=\"center\"><div id=\"SL_bbl_help\" title=\"Ayuda\" style=\"background: rgba(0, 0, 0, 0) url(\" moz-extension:=\"\" 3a6e0bcb-7eac-40ca-8c9f-c9aa18168b9b=\"\" content=\"\" img=\"\" util=\"\" bhelp.png\")=\"\" repeat=\"\" scroll=\"\" 0%=\"\" 0%;\"=\"\"></div></td><td class=\"SL_td\" width=\"15%\" align=\"right\"><div id=\"SL_pin\" class=\"SL_pin_off\" title=\"Fijar la ventana de traducción\" style=\"background: rgba(0, 0, 0, 0) url(\" moz-extension:=\"\" 3a6e0bcb-7eac-40ca-8c9f-c9aa18168b9b=\"\" content=\"\" img=\"\" util=\"\" pin-off.png\")=\"\" repeat=\"\" scroll=\"\" 0%=\"\" 0%;\"=\"\"></div></td></tr></tbody></table></div></div><div id=\"SL_shadow_translation_result\" style=\"visibility: visible;\"></div><div id=\"SL_loading\" class=\"SL_loading\" style=\"background: rgba(0, 0, 0, 0) url(\" moz-extension:=\"\" 3a6e0bcb-7eac-40ca-8c9f-c9aa18168b9b=\"\" content=\"\" img=\"\" util=\"\" loading.gif\")=\"\" repeat=\"\" scroll=\"\" 0%=\"\" 0%;\"=\"\"></div><div id=\"SL_player2\" style=\"display: none;\"></div><div id=\"SL_alert100\" style=\"display: none;\">La función de sonido está limitada a 200 caracteres</div><div id=\"SL_Balloon_options\" style=\"background: rgb(255, 255, 255) url(\" moz-extension:=\"\" 3a6e0bcb-7eac-40ca-8c9f-c9aa18168b9b=\"\" content=\"\" img=\"\" util=\"\" bg3.png\")=\"\" repeat=\"\" scroll=\"\" 0%=\"\" 0%;\"=\"\"><div id=\"SL_arrow_down\" style=\"background: rgba(0, 0, 0, 0) url(\" moz-extension:=\"\" 3a6e0bcb-7eac-40ca-8c9f-c9aa18168b9b=\"\" content=\"\" img=\"\" util=\"\" down.png\")=\"\" repeat=\"\" scroll=\"\" 0%=\"\" 0%;=\"\" display:=\"\" block;\"=\"\"></div><table id=\"SL_tbl_opt\" width=\"100%\"><tbody><tr><td class=\"SL_td\" width=\"5%\" align=\"center\"><input id=\"SL_BBL_locer\" type=\"checkbox\" checked=\"1\" title=\"Mostrar el botón ImTranslator 3 segundos\"></td><td class=\"SL_td\" width=\"5%\" align=\"left\"><div id=\"SL_BBL_IMG\" title=\"Mostrar el botón ImTranslator 3 segundos\" style=\"background: rgba(0, 0, 0, 0) url(\" moz-extension:=\"\" 3a6e0bcb-7eac-40ca-8c9f-c9aa18168b9b=\"\" content=\"\" img=\"\" util=\"\" bbl-logo.png\")=\"\" repeat=\"\" scroll=\"\" 0%=\"\" 0%;\"=\"\"></div></td><td class=\"SL_td\" width=\"70%\" align=\"center\"><a href=\"moz-extension://3a6e0bcb-7eac-40ca-8c9f-c9aa18168b9b/content/html/options/options.html?bbl\" target=\"_blank\" class=\"SL_options\" id=\"SL_opt1\" title=\"Mostrar opciones\">Opciones</a> : <a href=\"moz-extension://3a6e0bcb-7eac-40ca-8c9f-c9aa18168b9b/content/html/options/options.html?hist\" target=\"_blank\" class=\"SL_options\" id=\"SL_opt2\" title=\"Historial de traducciones\">Historia</a> : <a href=\"moz-extension://3a6e0bcb-7eac-40ca-8c9f-c9aa18168b9b/content/html/options/options.html?feed\" target=\"_blank\" class=\"SL_options\" id=\"SL_opt3\" title=\"ImTranslator Feedback\">Feedback</a> : <a href=\"http://imtranslator.net/extensions/?tp=ff-ImTranslator&amp;a=0\" target=\"_blank\" class=\"SL_options\" id=\"SL_opt4\" title=\"Hacer una contribución\">Donate</a></td><td class=\"SL_td\" width=\"15%\" align=\"right\"><span id=\"SL_Balloon_Close\" class=\"SL_options\" title=\"Cerrar\">Cerrar</span></td></tr></tbody></table></div></div></div>','2020-01-02 21:01:08','2020-05-05 12:12:34',6,6),
 (2,2,'Meeting 2',6,'2020-05-07 09:00:00','2020-05-07 11:00:00','<b>Pruebas 2</b><div id=\"SL_balloon_obj\" alt=\"0\" style=\"display: block;\"><div id=\"SL_button\" class=\"SL_ImTranslatorLogo\" style=\"background: rgba(0, 0, 0, 0) url(\" moz-extension:=\"\" 3a6e0bcb-7eac-40ca-8c9f-c9aa18168b9b=\"\" content=\"\" img=\"\" util=\"\" imtranslator-s.png\")=\"\" repeat=\"\" scroll=\"\" 0%=\"\" 0%;=\"\" display:=\"\" none;=\"\" opacity:=\"\" 1;\"=\"\"></div><div id=\"SL_shadow_translation_result2\" style=\"display: none;\"></div><div id=\"SL_shadow_translator\" style=\"left: 0px; top: 9px; display: none;\"><div id=\"SL_planshet\"><div id=\"SL_arrow_up\" style=\"background: rgba(0, 0, 0, 0) url(\" moz-extension:=\"\" 3a6e0bcb-7eac-40ca-8c9f-c9aa18168b9b=\"\" content=\"\" img=\"\" util=\"\" up.png\")=\"\" repeat=\"\" scroll=\"\" 0%=\"\" 0%;=\"\" display:=\"\" none;\"=\"\"></div><div id=\"SL_Bproviders\"></div><div id=\"SL_alert_bbl\" style=\"display: none;\"><div id=\"SLHKclose\" style=\"background: rgba(0, 0, 0, 0) url(\" moz-extension:=\"\" 3a6e0bcb-7eac-40ca-8c9f-c9aa18168b9b=\"\" content=\"\" img=\"\" util=\"\" delete.png\")=\"\" repeat=\"\" scroll=\"\" 0%=\"\" 0%;\"=\"\"></div><div id=\"SL_alert_cont\"></div></div><div id=\"SL_TB\"><table id=\"SL_tables\" cellspacing=\"1\"><tbody><tr><td class=\"SL_td\" width=\"10%\" align=\"right\"><input id=\"SL_locer\" type=\"checkbox\" title=\"Fijar idioma\"></td><td class=\"SL_td\" width=\"20%\" align=\"left\"><select id=\"SL_lng_from\" class=\"SL_lngs\" style=\"background: rgb(255, 255, 255) url(\" moz-extension:=\"\" 3a6e0bcb-7eac-40ca-8c9f-c9aa18168b9b=\"\" content=\"\" img=\"\" util=\"\" select.png\")=\"\" no-repeat=\"\" scroll=\"\" 100%=\"\" 0px;\"=\"\"><option value=\"auto\">Detectar idioma</option><option value=\"af\">Afrikáans</option><option value=\"sq\">Albanés</option><option value=\"de\">Alemán</option><option value=\"am\">Amhárico</option><option value=\"ar\">Árabe</option><option value=\"hy\">Armenio</option><option value=\"az\">Azerí</option><option value=\"bn\">Bengalí</option><option value=\"be\">Bielorruso</option><option value=\"my\">Birmano</option><option value=\"bs\">Bosnio</option><option value=\"bg\">Búlgaro</option><option value=\"km\">Camboyano</option><option value=\"kn\">Canarés</option><option value=\"ca\">Catalán</option><option value=\"ceb\">Cebuano</option><option value=\"cs\">Checo</option><option value=\"ny\">Chichewa</option><option value=\"zh-CN\">Chino simp</option><option value=\"zh-TW\">Chino trad</option><option value=\"si\">Cincalés</option><option value=\"ko\">Coreano</option><option value=\"co\">Corso</option><option value=\"ht\">Criollo haitiano</option><option value=\"hr\">Croata</option><option value=\"da\">Danés</option><option value=\"sk\">Eslovaco</option><option value=\"sl\">Esloveno</option><option value=\"es\">Español</option><option value=\"eo\">Esperanto</option><option value=\"et\">Estonio</option><option value=\"eu\">Euskera</option><option value=\"fi\">Finlandés</option><option value=\"fr\">Francés</option><option value=\"fy\">Frisio</option><option value=\"gd\">Gaélico escocés</option><option value=\"cy\">Galés</option><option value=\"gl\">Gallego</option><option value=\"ka\">Georgiano</option><option value=\"el\">Griego</option><option value=\"gu\">Gujarati</option><option value=\"ha\">Hausa</option><option value=\"haw\">Hawaiano</option><option value=\"iw\">Hebreo</option><option value=\"hi\">Hindi</option><option value=\"hmn\">Hmong</option><option value=\"nl\">Holandés</option><option value=\"hu\">Húngaro</option><option value=\"ig\">Igbo</option><option value=\"id\">Indonesio</option><option value=\"en\">Inglés</option><option value=\"ga\">Irlandés</option><option value=\"is\">Islandés</option><option value=\"it\">Italiano</option><option value=\"ja\">Japonés</option><option value=\"jw\">Javanés</option><option value=\"kk\">Kazajo</option><option value=\"ky\">Kirguís</option><option value=\"ku\">Kurdo</option><option value=\"lo\">Lao</option><option value=\"la\">Latín</option><option value=\"lv\">Letón</option><option value=\"lt\">Lituano</option><option value=\"lb\">Luxemburgués</option><option value=\"mk\">Macedonio</option><option value=\"ml\">Malayalam</option><option value=\"ms\">Malayo</option><option value=\"mg\">Malgache</option><option value=\"mt\">Maltés</option><option value=\"mi\">Maorí</option><option value=\"mr\">Maratí</option><option value=\"mn\">Mongol</option><option value=\"ne\">Nepalí</option><option value=\"no\">Noruego</option><option value=\"pa\">Panyabí</option><option value=\"ps\">Pastún</option><option value=\"fa\">Persa</option><option value=\"pl\">Polaco</option><option value=\"pt\">Portugués</option><option value=\"ro\">Rumano</option><option value=\"ru\">Ruso</option><option value=\"sm\">Samoano</option><option value=\"sr\">Serbio</option><option value=\"st\">Sesoto</option><option value=\"sn\">Shona</option><option value=\"sd\">Sindhi</option><option value=\"so\">Somalí</option><option value=\"sw\">Suajili</option><option value=\"sv\">Sueco</option><option value=\"su\">Sundanés</option><option value=\"tl\">Tagalo</option><option value=\"th\">Tailandés</option><option value=\"ta\">Tamil</option><option value=\"tg\">Tayiko</option><option value=\"te\">Telugu</option><option value=\"tr\">Turco</option><option value=\"uk\">Ucraniano</option><option value=\"ur\">Urdu</option><option value=\"uz\">Uzbeco</option><option value=\"vi\">Vietnamita</option><option value=\"xh\">Xhosa</option><option value=\"yi\">Yidis</option><option value=\"yo\">Yoruba</option><option value=\"zu\">Zulú</option></select></td><td class=\"SL_td\" width=\"3\" align=\"center\"><div id=\"SL_switch_b\" title=\"Cambiar idiomas\" style=\"background: rgba(0, 0, 0, 0) url(\" moz-extension:=\"\" 3a6e0bcb-7eac-40ca-8c9f-c9aa18168b9b=\"\" content=\"\" img=\"\" util=\"\" switchb.png\")=\"\" repeat=\"\" scroll=\"\" 0%=\"\" 0%;\"=\"\"></div></td><td class=\"SL_td\" width=\"20%\" align=\"left\"><select id=\"SL_lng_to\" class=\"SL_lngs\" style=\"background: rgb(255, 255, 255) url(\" moz-extension:=\"\" 3a6e0bcb-7eac-40ca-8c9f-c9aa18168b9b=\"\" content=\"\" img=\"\" util=\"\" select.png\")=\"\" no-repeat=\"\" scroll=\"\" 100%=\"\" 0px;\"=\"\"><option value=\"af\">Afrikáans</option><option value=\"sq\">Albanés</option><option value=\"de\">Alemán</option><option value=\"am\">Amhárico</option><option value=\"ar\">Árabe</option><option value=\"hy\">Armenio</option><option value=\"az\">Azerí</option><option value=\"bn\">Bengalí</option><option value=\"be\">Bielorruso</option><option value=\"my\">Birmano</option><option value=\"bs\">Bosnio</option><option value=\"bg\">Búlgaro</option><option value=\"km\">Camboyano</option><option value=\"kn\">Canarés</option><option value=\"ca\">Catalán</option><option value=\"ceb\">Cebuano</option><option value=\"cs\">Checo</option><option value=\"ny\">Chichewa</option><option value=\"zh-CN\">Chino simp</option><option value=\"zh-TW\">Chino trad</option><option value=\"si\">Cincalés</option><option value=\"ko\">Coreano</option><option value=\"co\">Corso</option><option value=\"ht\">Criollo haitiano</option><option value=\"hr\">Croata</option><option value=\"da\">Danés</option><option value=\"sk\">Eslovaco</option><option value=\"sl\">Esloveno</option><option selected=\"selected\" value=\"es\">Español</option><option value=\"eo\">Esperanto</option><option value=\"et\">Estonio</option><option value=\"eu\">Euskera</option><option value=\"fi\">Finlandés</option><option value=\"fr\">Francés</option><option value=\"fy\">Frisio</option><option value=\"gd\">Gaélico escocés</option><option value=\"cy\">Galés</option><option value=\"gl\">Gallego</option><option value=\"ka\">Georgiano</option><option value=\"el\">Griego</option><option value=\"gu\">Gujarati</option><option value=\"ha\">Hausa</option><option value=\"haw\">Hawaiano</option><option value=\"iw\">Hebreo</option><option value=\"hi\">Hindi</option><option value=\"hmn\">Hmong</option><option value=\"nl\">Holandés</option><option value=\"hu\">Húngaro</option><option value=\"ig\">Igbo</option><option value=\"id\">Indonesio</option><option value=\"en\">Inglés</option><option value=\"ga\">Irlandés</option><option value=\"is\">Islandés</option><option value=\"it\">Italiano</option><option value=\"ja\">Japonés</option><option value=\"jw\">Javanés</option><option value=\"kk\">Kazajo</option><option value=\"ky\">Kirguís</option><option value=\"ku\">Kurdo</option><option value=\"lo\">Lao</option><option value=\"la\">Latín</option><option value=\"lv\">Letón</option><option value=\"lt\">Lituano</option><option value=\"lb\">Luxemburgués</option><option value=\"mk\">Macedonio</option><option value=\"ml\">Malayalam</option><option value=\"ms\">Malayo</option><option value=\"mg\">Malgache</option><option value=\"mt\">Maltés</option><option value=\"mi\">Maorí</option><option value=\"mr\">Maratí</option><option value=\"mn\">Mongol</option><option value=\"ne\">Nepalí</option><option value=\"no\">Noruego</option><option value=\"pa\">Panyabí</option><option value=\"ps\">Pastún</option><option value=\"fa\">Persa</option><option value=\"pl\">Polaco</option><option value=\"pt\">Portugués</option><option value=\"ro\">Rumano</option><option value=\"ru\">Ruso</option><option value=\"sm\">Samoano</option><option value=\"sr\">Serbio</option><option value=\"st\">Sesoto</option><option value=\"sn\">Shona</option><option value=\"sd\">Sindhi</option><option value=\"so\">Somalí</option><option value=\"sw\">Suajili</option><option value=\"sv\">Sueco</option><option value=\"su\">Sundanés</option><option value=\"tl\">Tagalo</option><option value=\"th\">Tailandés</option><option value=\"ta\">Tamil</option><option value=\"tg\">Tayiko</option><option value=\"te\">Telugu</option><option value=\"tr\">Turco</option><option value=\"uk\">Ucraniano</option><option value=\"ur\">Urdu</option><option value=\"uz\">Uzbeco</option><option value=\"vi\">Vietnamita</option><option value=\"xh\">Xhosa</option><option value=\"yi\">Yidis</option><option value=\"yo\">Yoruba</option><option value=\"zu\">Zulú</option></select></td><td class=\"SL_td\" width=\"8%\" align=\"center\"><div id=\"SL_TTS_voice\" title=\"undefined\" style=\"background: rgba(0, 0, 0, 0) url(\" moz-extension:=\"\" 3a6e0bcb-7eac-40ca-8c9f-c9aa18168b9b=\"\" content=\"\" img=\"\" util=\"\" ttsvoice.png\")=\"\" repeat=\"\" scroll=\"\" 0%=\"\" 0%;\"=\"\"></div></td><td class=\"SL_td\" width=\"8%\" align=\"center\"><div id=\"SL_copy\" title=\"Copiar\" class=\"SL_copy\" style=\"background: rgba(0, 0, 0, 0) url(\" moz-extension:=\"\" 3a6e0bcb-7eac-40ca-8c9f-c9aa18168b9b=\"\" content=\"\" img=\"\" util=\"\" copy.png\")=\"\" repeat=\"\" scroll=\"\" 0%=\"\" 0%;\"=\"\"><div id=\"SL_copy_tip\"></div></div></td><td class=\"SL_td\" width=\"8%\" align=\"center\"><div id=\"SL_bbl_font_patch\"></div><div id=\"SL_bbl_font\" title=\"Тamaño de fuente\" class=\"SL_bbl_font\" style=\"background: rgba(0, 0, 0, 0) url(\" moz-extension:=\"\" 3a6e0bcb-7eac-40ca-8c9f-c9aa18168b9b=\"\" content=\"\" img=\"\" util=\"\" font.png\")=\"\" repeat=\"\" scroll=\"\" 0%=\"\" 0%;\"=\"\"></div></td><td class=\"SL_td\" width=\"8%\" align=\"center\"><div id=\"SL_bbl_help\" title=\"Ayuda\" style=\"background: rgba(0, 0, 0, 0) url(\" moz-extension:=\"\" 3a6e0bcb-7eac-40ca-8c9f-c9aa18168b9b=\"\" content=\"\" img=\"\" util=\"\" bhelp.png\")=\"\" repeat=\"\" scroll=\"\" 0%=\"\" 0%;\"=\"\"></div></td><td class=\"SL_td\" width=\"15%\" align=\"right\"><div id=\"SL_pin\" class=\"SL_pin_off\" title=\"Fijar la ventana de traducción\" style=\"background: rgba(0, 0, 0, 0) url(\" moz-extension:=\"\" 3a6e0bcb-7eac-40ca-8c9f-c9aa18168b9b=\"\" content=\"\" img=\"\" util=\"\" pin-off.png\")=\"\" repeat=\"\" scroll=\"\" 0%=\"\" 0%;\"=\"\"></div></td></tr></tbody></table></div></div><div id=\"SL_shadow_translation_result\" style=\"visibility: visible;\"></div><div id=\"SL_loading\" class=\"SL_loading\" style=\"background: rgba(0, 0, 0, 0) url(\" moz-extension:=\"\" 3a6e0bcb-7eac-40ca-8c9f-c9aa18168b9b=\"\" content=\"\" img=\"\" util=\"\" loading.gif\")=\"\" repeat=\"\" scroll=\"\" 0%=\"\" 0%;\"=\"\"></div><div id=\"SL_player2\" style=\"display: none;\"></div><div id=\"SL_alert100\" style=\"display: none;\">La función de sonido está limitada a 200 caracteres</div><div id=\"SL_Balloon_options\" style=\"background: rgb(255, 255, 255) url(\" moz-extension:=\"\" 3a6e0bcb-7eac-40ca-8c9f-c9aa18168b9b=\"\" content=\"\" img=\"\" util=\"\" bg3.png\")=\"\" repeat=\"\" scroll=\"\" 0%=\"\" 0%;\"=\"\"><div id=\"SL_arrow_down\" style=\"background: rgba(0, 0, 0, 0) url(\" moz-extension:=\"\" 3a6e0bcb-7eac-40ca-8c9f-c9aa18168b9b=\"\" content=\"\" img=\"\" util=\"\" down.png\")=\"\" repeat=\"\" scroll=\"\" 0%=\"\" 0%;=\"\" display:=\"\" block;\"=\"\"></div><table id=\"SL_tbl_opt\" width=\"100%\"><tbody><tr><td class=\"SL_td\" width=\"5%\" align=\"center\"><input id=\"SL_BBL_locer\" type=\"checkbox\" checked=\"1\" title=\"Mostrar el botón ImTranslator 3 segundos\"></td><td class=\"SL_td\" width=\"5%\" align=\"left\"><div id=\"SL_BBL_IMG\" title=\"Mostrar el botón ImTranslator 3 segundos\" style=\"background: rgba(0, 0, 0, 0) url(\" moz-extension:=\"\" 3a6e0bcb-7eac-40ca-8c9f-c9aa18168b9b=\"\" content=\"\" img=\"\" util=\"\" bbl-logo.png\")=\"\" repeat=\"\" scroll=\"\" 0%=\"\" 0%;\"=\"\"></div></td><td class=\"SL_td\" width=\"70%\" align=\"center\"><a href=\"moz-extension://3a6e0bcb-7eac-40ca-8c9f-c9aa18168b9b/content/html/options/options.html?bbl\" target=\"_blank\" class=\"SL_options\" id=\"SL_opt1\" title=\"Mostrar opciones\">Opciones</a> : <a href=\"moz-extension://3a6e0bcb-7eac-40ca-8c9f-c9aa18168b9b/content/html/options/options.html?hist\" target=\"_blank\" class=\"SL_options\" id=\"SL_opt2\" title=\"Historial de traducciones\">Historia</a> : <a href=\"moz-extension://3a6e0bcb-7eac-40ca-8c9f-c9aa18168b9b/content/html/options/options.html?feed\" target=\"_blank\" class=\"SL_options\" id=\"SL_opt3\" title=\"ImTranslator Feedback\">Feedback</a> : <a href=\"http://imtranslator.net/extensions/?tp=ff-ImTranslator&amp;a=0\" target=\"_blank\" class=\"SL_options\" id=\"SL_opt4\" title=\"Hacer una contribución\">Donate</a></td><td class=\"SL_td\" width=\"15%\" align=\"right\"><span id=\"SL_Balloon_Close\" class=\"SL_options\" title=\"Cerrar\">Cerrar</span></td></tr></tbody></table></div></div></div>','2020-01-03 18:48:10','2020-05-05 12:12:56',6,6),
 (3,3,'Meeting 3',6,'2020-05-07 18:00:00','2020-05-07 19:00:00','Pruebas<br>','2020-01-07 18:10:41','2020-05-05 12:13:48',6,6),
 (4,2,'meeting 4',6,'2020-05-07 14:00:00','2020-05-07 16:00:00','Pruebas','2020-01-07 18:12:17','2020-05-05 12:13:10',6,6),
 (5,2,'Meeting 5',6,'2020-05-08 10:00:00','2020-05-08 12:00:00','Pruebas','2020-01-07 18:16:48','2020-05-05 12:13:27',6,6),
 (6,3,'Meeting 6',6,'2020-05-11 19:00:00','2020-05-11 20:00:00','','2020-01-09 18:17:17','2020-05-05 12:14:25',6,6);
/*!40000 ALTER TABLE `meetings` ENABLE KEYS */;


--
-- Definition of table `meetings_audit`
--

DROP TABLE IF EXISTS `meetings_audit`;
CREATE TABLE `meetings_audit` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `datetime` datetime NOT NULL,
  `ip` varchar(40) NOT NULL,
  `user` varchar(300) DEFAULT NULL,
  `table` varchar(300) DEFAULT NULL,
  `action` varchar(250) NOT NULL,
  `description` mediumtext,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=115 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `meetings_audit`
--

/*!40000 ALTER TABLE `meetings_audit` DISABLE KEYS */;
INSERT INTO `meetings_audit` (`id`,`datetime`,`ip`,`user`,`table`,`action`,`description`) VALUES 
 (1,'2020-01-02 13:53:46','::1','admin','users','login',''),
 (2,'2020-01-02 13:55:10','::1','admin','users','login',''),
 (3,'2020-01-02 20:37:27','::1','admin','users','login',''),
 (4,'2020-01-02 20:37:38','::1','admin','users','edit','---Keys\r\nuser_id : 6\r\n---Fields\r\ncolor_identifier [old]: #FFFFFF\r\ncolor_identifier [new]: #F70D0D\r\n'),
 (5,'2020-01-02 20:37:49','::1','admin','users','edit','---Keys\r\nuser_id : 7\r\n---Fields\r\ncolor_identifier [old]: #FFFFFF\r\ncolor_identifier [new]: #7468F7\r\n'),
 (6,'2020-01-02 20:37:56','::1','admin','users','edit','---Keys\r\nuser_id : 8\r\n---Fields\r\ncolor_identifier [old]: #FFFFFF\r\ncolor_identifier [new]: #2FF01D\r\n'),
 (7,'2020-01-02 21:02:45','::1','admin','meetings','add','---Keys\r\nidmeetings : 1\r\n---Fields\r\nprojects_project_id [new]: 2\r\nname [new]: Meeting 1\r\nowner [new]: 6\r\nstart_date [new]: 2020-01-02 21:00:00\r\nend_date [new]: 2020-01-02 22:00:00\r\ndescription [new]: <div>informe.</div><div><ol><li>Paso 1</li><li>Paso 2<br></li></ol></div><div id=\"SL_balloon_obj\" alt=\"0\" style=\"display: block;\"><div id=\"SL_button\" class=\"SL_ImTranslatorLogo\" style=\"background: rgba(0, 0, 0, 0) url(&quot;moz-extension://3a6e0bcb-7eac-40ca-8c9f-c9aa18168b9b/content/img/util/imtran\r\ncreated [new]: 2020-01-02 21:01:08\r\nupdated [new]: 2020-01-02 21:01:08\r\ncreator [new]: 6\r\nmodifier [new]: 6\r\n'),
 (8,'2020-01-02 21:11:59','::1','admin','super_catalog','edit','---Keys\r\nidsuper_catalog : 4\r\n---Fields\r\nsuper_code [old]: SITUATION_TASK\r\nsuper_code [new]: RELATION_USER\r\ndescription [old]: Situación de las Tareas\r\ndescription [new]: Situación de la relación de usuarios y reuniones\r\n'),
 (9,'2020-01-02 21:12:22','::1','admin','catalog','delete','---Keys\r\nidcatalog : 11\r\n---Fields\r\nsuper_catalog_idsuper_catalog [old]: 4\r\nlanguage [old]: English\r\ncatalog_num [old]: 0\r\ncatalog_code [old]: Good\r\ndescription [old]: Green\r\n'),
 (10,'2020-01-02 21:12:22','::1','admin','catalog','delete','---Keys\r\nidcatalog : 12\r\n---Fields\r\nsuper_catalog_idsuper_catalog [old]: 4\r\nlanguage [old]: English\r\ncatalog_num [old]: 1\r\ncatalog_code [old]: Warning\r\ndescription [old]: Orange\r\n'),
 (11,'2020-01-02 21:12:22','::1','admin','catalog','delete','---Keys\r\nidcatalog : 13\r\n---Fields\r\nsuper_catalog_idsuper_catalog [old]: 4\r\nlanguage [old]: English\r\ncatalog_num [old]: 2\r\ncatalog_code [old]: Problems\r\ndescription [old]: Red\r\n'),
 (12,'2020-01-02 21:12:22','::1','admin','catalog','delete','---Keys\r\nidcatalog : 14\r\n---Fields\r\nsuper_catalog_idsuper_catalog [old]: 4\r\nlanguage [old]: English\r\ncatalog_num [old]: 3\r\ncatalog_code [old]: Locked\r\ndescription [old]: Red + Locked\r\n'),
 (13,'2020-01-02 21:12:22','::1','admin','catalog','delete','---Keys\r\nidcatalog : 15\r\n---Fields\r\nsuper_catalog_idsuper_catalog [old]: 4\r\nlanguage [old]: Spanish\r\ncatalog_num [old]: 0\r\ncatalog_code [old]: Bien\r\ndescription [old]: Verde\r\n'),
 (14,'2020-01-02 21:12:22','::1','admin','catalog','delete','---Keys\r\nidcatalog : 16\r\n---Fields\r\nsuper_catalog_idsuper_catalog [old]: 4\r\nlanguage [old]: Spanish\r\ncatalog_num [old]: 1\r\ncatalog_code [old]: Advertencia\r\ndescription [old]: Naranja\r\n'),
 (15,'2020-01-02 21:12:22','::1','admin','catalog','delete','---Keys\r\nidcatalog : 17\r\n---Fields\r\nsuper_catalog_idsuper_catalog [old]: 4\r\nlanguage [old]: Spanish\r\ncatalog_num [old]: 2\r\ncatalog_code [old]: Problemas\r\ndescription [old]: Rojo\r\n'),
 (16,'2020-01-02 21:12:22','::1','admin','catalog','delete','---Keys\r\nidcatalog : 18\r\n---Fields\r\nsuper_catalog_idsuper_catalog [old]: 4\r\nlanguage [old]: Spanish\r\ncatalog_num [old]: 3\r\ncatalog_code [old]: Bloqueado\r\ndescription [old]: Rojo + Bloqueado\r\n'),
 (17,'2020-01-02 21:13:22','::1','admin','catalog','add','---Keys\r\nidcatalog : 40\r\n---Fields\r\nsuper_catalog_idsuper_catalog [new]: 4\r\nlanguage [new]: English\r\ncatalog_num [new]: 0\r\ncatalog_code [new]: Owner\r\ndescription [new]: Owner of Meeting\r\n'),
 (18,'2020-01-02 21:14:06','::1','admin','catalog','add','---Keys\r\nidcatalog : 41\r\n---Fields\r\nsuper_catalog_idsuper_catalog [new]: 4\r\nlanguage [new]: English\r\ncatalog_num [new]: 1\r\ncatalog_code [new]: Necessary\r\n'),
 (19,'2020-01-02 21:14:43','::1','admin','catalog','add','---Keys\r\nidcatalog : 42\r\n---Fields\r\nsuper_catalog_idsuper_catalog [new]: 4\r\nlanguage [new]: English\r\ncatalog_num [new]: 2\r\ncatalog_code [new]: Optional\r\n'),
 (20,'2020-01-02 21:15:19','::1','admin','catalog','add','---Keys\r\nidcatalog : 43\r\n---Fields\r\nsuper_catalog_idsuper_catalog [new]: 4\r\nlanguage [new]: English\r\ncatalog_num [new]: 3\r\ncatalog_code [new]: Manage Resources\r\n'),
 (21,'2020-01-02 21:15:44','::1','admin','catalog','add','---Keys\r\nidcatalog : 44\r\n---Fields\r\nsuper_catalog_idsuper_catalog [new]: 4\r\nlanguage [new]: English\r\ncatalog_num [new]: 4\r\ncatalog_code [new]: Informed\r\n'),
 (22,'2020-01-02 21:16:34','::1','admin','catalog','add','---Keys\r\nidcatalog : 45\r\n---Fields\r\nsuper_catalog_idsuper_catalog [new]: 4\r\nlanguage [new]: Spanish\r\ncatalog_num [new]: 0\r\ncatalog_code [new]: Propietario\r\ndescription [new]: Propietario de la Reunión\r\n'),
 (23,'2020-01-02 21:16:48','::1','admin','catalog','add','---Keys\r\nidcatalog : 46\r\n---Fields\r\nsuper_catalog_idsuper_catalog [new]: 4\r\nlanguage [new]: Spanish\r\ncatalog_num [new]: 1\r\ncatalog_code [new]: Necesario\r\n'),
 (24,'2020-01-02 21:16:58','::1','admin','catalog','add','---Keys\r\nidcatalog : 47\r\n---Fields\r\nsuper_catalog_idsuper_catalog [new]: 4\r\nlanguage [new]: Spanish\r\ncatalog_num [new]: 2\r\ncatalog_code [new]: Opcional\r\n'),
 (25,'2020-01-02 21:17:25','::1','admin','catalog','add','---Keys\r\nidcatalog : 48\r\n---Fields\r\nsuper_catalog_idsuper_catalog [new]: 4\r\nlanguage [new]: Spanish\r\ncatalog_num [new]: 3\r\ncatalog_code [new]: Gestor de los recursos\r\n'),
 (26,'2020-01-02 21:17:42','::1','admin','catalog','add','---Keys\r\nidcatalog : 49\r\n---Fields\r\nsuper_catalog_idsuper_catalog [new]: 4\r\nlanguage [new]: Spanish\r\ncatalog_num [new]: 4\r\ncatalog_code [new]: Informado\r\n'),
 (27,'2020-01-02 21:21:41','::1','admin','super_catalog','add','---Keys\r\nidsuper_catalog : 9\r\n---Fields\r\nsuper_code [new]: ACEPTATION_USER\r\ndescription [new]: Aceptación de los Usuarios a la Reunión\r\n'),
 (28,'2020-01-02 21:22:21','::1','admin','catalog','add','---Keys\r\nidcatalog : 50\r\n---Fields\r\nsuper_catalog_idsuper_catalog [new]: 9\r\nlanguage [new]: English\r\ncatalog_num [new]: 0\r\ncatalog_code [new]: Pending\r\n'),
 (29,'2020-01-02 21:22:50','::1','admin','catalog','add','---Keys\r\nidcatalog : 51\r\n---Fields\r\nsuper_catalog_idsuper_catalog [new]: 9\r\nlanguage [new]: English\r\ncatalog_num [new]: 1\r\ncatalog_code [new]: Accepted\r\n'),
 (30,'2020-01-02 21:23:09','::1','admin','catalog','add','---Keys\r\nidcatalog : 52\r\n---Fields\r\nsuper_catalog_idsuper_catalog [new]: 9\r\nlanguage [new]: English\r\ncatalog_num [new]: 2\r\ncatalog_code [new]: Rejected\r\n'),
 (31,'2020-01-02 21:23:24','::1','admin','catalog','add','---Keys\r\nidcatalog : 53\r\n---Fields\r\nsuper_catalog_idsuper_catalog [new]: 9\r\nlanguage [new]: Spanish\r\ncatalog_num [new]: 0\r\ncatalog_code [new]: Pendiente\r\n'),
 (32,'2020-01-02 21:23:34','::1','admin','catalog','add','---Keys\r\nidcatalog : 54\r\n---Fields\r\nsuper_catalog_idsuper_catalog [new]: 9\r\nlanguage [new]: Spanish\r\ncatalog_num [new]: 1\r\ncatalog_code [new]: Aceptada\r\n'),
 (33,'2020-01-02 21:23:48','::1','admin','catalog','add','---Keys\r\nidcatalog : 55\r\n---Fields\r\nsuper_catalog_idsuper_catalog [new]: 9\r\nlanguage [new]: Spanish\r\ncatalog_num [new]: 2\r\ncatalog_code [new]: Rechazada\r\n'),
 (34,'2020-01-02 21:26:35','::1','admin','users_meetings','add','---Keys\r\nidusers_meetings : 1\r\n---Fields\r\nmeetings_idmeetings [new]: 1\r\nusers_user_id [new]: 7\r\nrelation_num [new]: 1\r\nacceptation_num [new]: 0\r\ncommentary [new]: Coment\r\n'),
 (35,'2020-01-02 21:34:27','::1','admin','config','add','---Keys\r\nconfig_id : 6\r\n---Fields\r\nname [new]: FOLDER_FILES\r\nvalue [new]: files\r\n'),
 (36,'2020-01-02 21:52:41','::1','admin','config','edit','---Keys\r\nconfig_id : 6\r\n---Fields\r\nvalue [old]: files\r\nvalue [new]: C:\\Apache24\\htdocs\\meetings\\files\r\n'),
 (37,'2020-01-02 21:53:12','::1','admin','config','edit','---Keys\r\nconfig_id : 6\r\n---Fields\r\nvalue [old]: C:\\Apache24\\htdocs\\meetings\\files\r\nvalue [new]: C:/Apache24/htdocs/meetings/files\r\n'),
 (38,'2020-01-02 21:53:23','::1','admin','users','logout',''),
 (39,'2020-01-02 21:53:29','::1','admin','users','login',''),
 (40,'2020-01-02 21:55:05','::1','admin','users','logout',''),
 (41,'2020-01-02 21:55:16','::1','admin','users','login',''),
 (42,'2020-01-03 13:00:28','::1','admin','config','edit','---Keys\r\nconfig_id : 6\r\n---Fields\r\nvalue [old]: C:/Apache24/htdocs/meetings/files\r\nvalue [new]: C:/Apache24/htdocs/meetings/files/\r\n'),
 (43,'2020-01-03 13:09:27','::1','admin','users','logout',''),
 (44,'2020-01-03 13:09:58','::1','admin','users','login',''),
 (45,'2020-01-03 13:10:09','::1','admin','config','edit','---Keys\r\nconfig_id : 1\r\n---Fields\r\nvalue [old]: http://localhost/meetings\r\nvalue [new]: files\r\n'),
 (46,'2020-01-03 13:11:33','::1','admin','users','logout',''),
 (47,'2020-01-03 13:11:40','::1','admin','users','login',''),
 (48,'2020-01-03 13:13:54','::1','admin','users','logout',''),
 (49,'2020-01-03 13:14:01','::1','admin','users','login',''),
 (50,'2020-01-03 13:14:15','::1','admin','config','edit','---Keys\r\nconfig_id : 6\r\n---Fields\r\nvalue [old]: C:/Apache24/htdocs/meetings/files/\r\nvalue [new]: files\r\n'),
 (51,'2020-01-03 13:14:19','::1','admin','users','logout',''),
 (52,'2020-01-03 13:14:26','::1','admin','users','login',''),
 (53,'2020-01-03 13:16:02','::1','admin','files_meetings','add','---Keys\r\nidfiles_meetings : 1\r\n---Fields\r\nmeetings_idmeetings [new]: 1\r\ndescription [new]: Pruebas\r\nfiles_content [new]: [{\"name\":\"files\\/meetings_002_udv9o5r8.png\",\"usrName\":\"meetings_002.png\",\"size\":705043,\"type\":\"image\\/png\",\"searchStr\":\"meetings_002.png,!:sStrEnd\"}]\r\n'),
 (54,'2020-01-03 13:16:53','::1','admin','meetings','edit','---Keys\r\nidmeetings : 1\r\n---Fields\r\ndescription [old]: <div>informe.</div><div><ol><li>Paso 1</li><li>Paso 2<br></li></ol></div><div id=\"SL_balloon_obj\" alt=\"0\" style=\"display: block;\"><div id=\"SL_button\" class=\"SL_ImTranslatorLogo\" style=\"background: rgba(0, 0, 0, 0) url(&quot;moz-extension://3a6e0bcb-7eac-40ca-8c9f-c9aa18168b9b/content/img/util/imtran\r\ndescription [new]: <div>informe.</div><div><ol><li>Paso 1</li><li>Paso 2<br></li></ol></div><div id=\"SL_balloon_obj\" alt=\"0\" style=\"display: block;\"><div id=\"SL_button\" class=\"SL_ImTranslatorLogo\" style=\"background: rgba(0, 0, 0, 0) url(\" moz-extension:=\"\" 3a6e0bcb-7eac-40ca-8c9f-c9aa18168b9b=\"\" content=\"\" img=\"\" util\r\nupdated [old]: 2020-01-02 21:01:08\r\nupdated [new]: 2020-01-03 13:16:53\r\n'),
 (55,'2020-01-03 18:50:04','::1','admin','meetings','add','---Keys\r\nidmeetings : 2\r\n---Fields\r\nprojects_project_id [new]: 2\r\nname [new]: Prueba 2\r\nowner [new]: 6\r\nstart_date [new]: 2020-01-07 09:00:00\r\nend_date [new]: 2020-01-07 11:00:00\r\ndescription [new]: <b>Pruebas</b>\r\ncreated [new]: 2020-01-03 18:48:10\r\nupdated [new]: 2020-01-03 18:48:10\r\ncreator [new]: 6\r\nmodifier [new]: 6\r\n'),
 (56,'2020-01-03 18:51:03','::1','admin','meetings','edit','---Keys\r\nidmeetings : 2\r\n---Fields\r\nname [old]: Prueba 2\r\nname [new]: Meeting 2\r\nupdated [old]: 2020-01-03 18:48:10\r\nupdated [new]: 2020-01-03 18:51:03\r\n'),
 (57,'2020-01-03 20:08:51','::1','admin','users_meetings','add','---Keys\r\nidusers_meetings : 2\r\n---Fields\r\nmeetings_idmeetings [new]: 2\r\nusers_user_id [new]: 7\r\nrelation_num [new]: 1\r\nacceptation_num [new]: 0\r\n'),
 (58,'2020-01-04 18:48:26','::1','admin','calendar','edit','---Keys\r\nidmeetings : 2\r\n---Fields\r\ndescription [old]: <b>Pruebas</b>\r\ndescription [new]: <b>Pruebas 2</b><div id=\"SL_balloon_obj\" alt=\"0\" style=\"display: block;\"><div id=\"SL_button\" class=\"SL_ImTranslatorLogo\" style=\"background: rgba(0, 0, 0, 0) url(&quot;moz-extension://3a6e0bcb-7eac-40ca-8c9f-c9aa18168b9b/content/img/util/imtranslator-s.png&quot;) repeat scroll 0% 0%; display: none; o\r\nupdated [old]: 2020-01-03 18:51:03\r\nupdated [new]: 2020-01-04 18:48:25\r\n'),
 (59,'2020-01-04 20:29:49','::1','admin','config','edit','---Keys\r\nconfig_id : 1\r\n---Fields\r\nname [old]: URL\r\nname [new]: URL2\r\n'),
 (60,'2020-01-04 20:30:36','::1','admin','config','edit','---Keys\r\nconfig_id : 1\r\n---Fields\r\nname [old]: URL2\r\nname [new]: URL\r\nvalue [old]: files\r\nvalue [new]: http://localhost/meetings/\r\n'),
 (61,'2020-01-04 20:31:11','::1','admin','config','edit','---Keys\r\nconfig_id : 5\r\n---Fields\r\nvalue [old]: http://localhost/meetings/meetings_ajax.php\r\nvalue [new]: meetings_ajax.php\r\n'),
 (62,'2020-01-04 20:31:30','::1','admin','config','edit','---Keys\r\nconfig_id : 1\r\n---Fields\r\nvalue [old]: http://localhost/meetings/\r\nvalue [new]: http://localhost/meetings\r\n'),
 (63,'2020-01-04 20:35:44','::1','admin','users','logout',''),
 (64,'2020-01-04 20:35:50','::1','admin','users','login',''),
 (65,'2020-01-04 20:39:54','::1','admin','config','edit','---Keys\r\nconfig_id : 5\r\n---Fields\r\nvalue [old]: meetings_ajax.php\r\nvalue [new]: calendar_ajax.php\r\n'),
 (66,'2020-01-04 20:39:59','::1','admin','users','logout',''),
 (67,'2020-01-04 20:40:07','::1','admin','users','login',''),
 (68,'2020-01-05 12:34:22','::1','admin','users','logout',''),
 (69,'2020-01-05 12:34:30','::1','admin','users','login',''),
 (70,'2020-01-05 12:38:57','::1','admin','users','login',''),
 (71,'2020-01-05 14:16:16','::1','admin','config','edit','---Keys\r\nconfig_id : 5\r\n---Fields\r\ngroup [old]: \r\ngroup [new]: No se utiliza\r\n'),
 (72,'2020-01-05 14:18:02','::1','admin','config','delete','---Keys\r\nconfig_id : 2\r\n---Fields\r\nname [old]: PLUGIN_PATH\r\nvalue [old]: /meetings/daypilot\r\n'),
 (73,'2020-01-05 14:18:02','::1','admin','config','delete','---Keys\r\nconfig_id : 4\r\n---Fields\r\nname [old]: NOTIFY\r\nvalue [old]: http://localhost/meetings/notify\r\n'),
 (74,'2020-01-05 14:18:02','::1','admin','config','delete','---Keys\r\nconfig_id : 5\r\n---Fields\r\nname [old]: MEETINGS_AJAX\r\nvalue [old]: calendar_ajax.php\r\ngroup [old]: No se utiliza\r\n'),
 (75,'2020-01-07 14:04:15','::1','admin','meetings','edit','---Keys\r\nidmeetings : 1\r\n---Fields\r\nstart_date [old]: 2020-01-02 21:00:00\r\nstart_date [new]: 2020-01-02 12:00:00\r\nend_date [old]: 2020-01-02 22:00:00\r\nend_date [new]: 2020-01-02 13:00:00\r\nupdated [old]: 2020-01-03 13:16:53\r\nupdated [new]: 2020-01-07 14:04:15\r\n'),
 (76,'2020-01-07 14:12:21','::1','admin','meetings','edit','---Keys\r\nidmeetings : 1\r\n---Fields\r\nname [old]: Meeting 1\r\nname [new]: Meeting 1 \"esto es una excepción\"\r\nupdated [old]: 2020-01-07 14:04:15\r\nupdated [new]: 2020-01-07 14:12:21\r\n'),
 (77,'2020-01-07 17:01:16','::1','admin','projects','edit','---Keys\r\nproject_id : 2\r\n---Fields\r\ncolor_identifier [old]: #222DA8\r\ncolor_identifier [new]: #AF2DCC\r\nupdated [old]: 2019-11-13 18:39:49\r\nupdated [new]: 2020-01-07 17:01:16\r\n'),
 (78,'2020-01-07 17:12:05','::1','admin','projects','edit','---Keys\r\nproject_id : 2\r\n---Fields\r\ndepartments_dept_id [old]: \r\ndepartments_dept_id [new]: 1\r\nupdated [old]: 2020-01-07 17:01:16\r\nupdated [new]: 2020-01-07 17:12:05\r\n'),
 (79,'2020-01-07 17:31:31','::1','admin','users_meetings','add','---Keys\r\nidusers_meetings : 3\r\n---Fields\r\nmeetings_idmeetings [new]: 1\r\nusers_user_id [new]: 6\r\nrelation_num [new]: 2\r\nacceptation_num [new]: 0\r\n'),
 (80,'2020-01-07 17:31:45','::1','admin','users_meetings','add','---Keys\r\nidusers_meetings : 4\r\n---Fields\r\nmeetings_idmeetings [new]: 1\r\nusers_user_id [new]: 8\r\nrelation_num [new]: 1\r\nacceptation_num [new]: 0\r\n'),
 (81,'2020-01-07 18:11:14','::1','admin','calendar','add','---Keys\r\nidmeetings : 3\r\n---Fields\r\nprojects_project_id [new]: 3\r\nname [new]: Meeting 3\r\nowner [new]: 6\r\nstart_date [new]: 2020-01-07 18:00:00\r\nend_date [new]: 2020-01-07 19:00:00\r\ndescription [new]: Pruebas<br>\r\ncreated [new]: 2020-01-07 18:10:41\r\nupdated [new]: 2020-01-07 18:10:41\r\ncreator [new]: 6\r\nmodifier [new]: 6\r\n'),
 (82,'2020-01-07 18:12:52','::1','admin','calendar','add','---Keys\r\nidmeetings : 4\r\n---Fields\r\nprojects_project_id [new]: 2\r\nname [new]: meeting 4\r\nowner [new]: 6\r\nstart_date [new]: 2020-01-07 14:00:00\r\nend_date [new]: 2020-01-07 19:40:00\r\ndescription [new]: Pruebas\r\ncreated [new]: 2020-01-07 18:12:17\r\nupdated [new]: 2020-01-07 18:12:17\r\ncreator [new]: 6\r\nmodifier [new]: 6\r\n'),
 (83,'2020-01-07 18:16:19','::1','admin','calendar','edit','---Keys\r\nidmeetings : 4\r\n---Fields\r\nend_date [old]: 2020-01-07 19:40:00\r\nend_date [new]: 2020-01-07 19:00:00\r\nupdated [old]: 2020-01-07 18:12:17\r\nupdated [new]: 2020-01-07 18:16:19\r\n'),
 (84,'2020-01-07 18:16:39','::1','admin','calendar','edit','---Keys\r\nidmeetings : 4\r\n---Fields\r\nend_date [old]: 2020-01-07 19:00:00\r\nend_date [new]: 2020-01-07 16:00:00\r\nupdated [old]: 2020-01-07 18:16:19\r\nupdated [new]: 2020-01-07 18:16:39\r\n'),
 (85,'2020-01-07 18:17:39','::1','admin','calendar','add','---Keys\r\nidmeetings : 5\r\n---Fields\r\nprojects_project_id [new]: 2\r\nname [new]: Meeting 5\r\nowner [new]: 6\r\nstart_date [new]: 2020-01-08 10:00:00\r\nend_date [new]: 2020-01-08 12:00:00\r\ndescription [new]: Pruebas\r\ncreated [new]: 2020-01-07 18:16:48\r\nupdated [new]: 2020-01-07 18:16:48\r\ncreator [new]: 6\r\nmodifier [new]: 6\r\n'),
 (86,'2020-01-07 19:02:49','::1','admin','users','logout',''),
 (87,'2020-01-09 18:14:14','::1','admin','users','login',''),
 (88,'2020-01-09 18:17:51','::1','admin','calendar','add','---Keys\r\nidmeetings : 6\r\n---Fields\r\nprojects_project_id [new]: 3\r\nname [new]: Meeting 6\r\nowner [new]: 6\r\nstart_date [new]: 2020-01-09 19:00:00\r\nend_date [new]: 2020-01-09 20:00:00\r\ncreated [new]: 2020-01-09 18:17:17\r\nupdated [new]: 2020-01-09 18:17:17\r\ncreator [new]: 6\r\nmodifier [new]: 6\r\n'),
 (89,'2020-01-09 18:28:32','::1','admin','users','login',''),
 (90,'2020-01-09 18:44:42','::1','admin','users','logout',''),
 (91,'2020-01-09 19:32:24','::1','admin','users','login',''),
 (92,'2020-01-09 19:37:46','::1','admin','users','logout',''),
 (93,'2020-01-12 21:55:51','::1','admin','users','login',''),
 (94,'2020-01-12 22:38:51','::1','admin','users','logout',''),
 (95,'2020-03-05 21:23:09','::1','admin','users','login',''),
 (96,'2020-03-06 14:07:34','::1','admin','users','login',''),
 (97,'2020-04-29 13:38:56','::1','admin','users','login',''),
 (98,'2020-04-29 13:54:00','::1','admin','users','login',''),
 (99,'2020-04-29 17:34:46','::1','admin','users','logout',''),
 (100,'2020-04-29 17:35:31','::1','admin','users','login',''),
 (101,'2020-05-04 17:19:04','::1','admin','users','logout',''),
 (102,'2020-05-04 17:19:10','::1','admin','users','login',''),
 (103,'2020-05-04 17:46:27','::1','admin','users','login',''),
 (104,'2020-05-04 17:47:19','::1','admin','users','logout',''),
 (105,'2020-05-04 17:56:14','::1','admin','users','login',''),
 (106,'2020-05-05 10:33:04','::1','admin','users','login',''),
 (107,'2020-05-05 12:12:34','::1','admin','meetings','edit','---Keys\r\nidmeetings : 1\r\n---Fields\r\nstart_date [old]: 2020-01-02 12:00:00\r\nstart_date [new]: 2020-05-04 12:00:00\r\nend_date [old]: 2020-01-02 13:00:00\r\nend_date [new]: 2020-05-04 13:00:00\r\nupdated [old]: 2020-01-07 14:12:21\r\nupdated [new]: 2020-05-05 12:12:34\r\n'),
 (108,'2020-05-05 12:12:56','::1','admin','meetings','edit','---Keys\r\nidmeetings : 2\r\n---Fields\r\nstart_date [old]: 2020-01-07 09:00:00\r\nstart_date [new]: 2020-05-07 09:00:00\r\nend_date [old]: 2020-01-07 11:00:00\r\nend_date [new]: 2020-05-07 11:00:00\r\ndescription [old]: <b>Pruebas 2</b><div id=\"SL_balloon_obj\" alt=\"0\" style=\"display: block;\"><div id=\"SL_button\" class=\"SL_ImTranslatorLogo\" style=\"background: rgba(0, 0, 0, 0) url(&quot;moz-extension://3a6e0bcb-7eac-40ca-8c9f-c9aa18168b9b/content/img/util/imtranslator-s.png&quot;) repeat scroll 0% 0%; display: none; o\r\ndescription [new]: <b>Pruebas 2</b><div id=\"SL_balloon_obj\" alt=\"0\" style=\"display: block;\"><div id=\"SL_button\" class=\"SL_ImTranslatorLogo\" style=\"background: rgba(0, 0, 0, 0) url(\" moz-extension:=\"\" 3a6e0bcb-7eac-40ca-8c9f-c9aa18168b9b=\"\" content=\"\" img=\"\" util=\"\" imtranslator-s.png\")=\"\" repeat=\"\" scroll=\"\" 0%=\"\" 0%;\r\nupdated [old]: 2020-01-04 18:48:25\r\nupdated [new]: 2020-05-05 12:12:56\r\n'),
 (109,'2020-05-05 12:13:10','::1','admin','meetings','edit','---Keys\r\nidmeetings : 4\r\n---Fields\r\nstart_date [old]: 2020-01-07 14:00:00\r\nstart_date [new]: 2020-05-07 14:00:00\r\nend_date [old]: 2020-01-07 16:00:00\r\nend_date [new]: 2020-05-07 16:00:00\r\nupdated [old]: 2020-01-07 18:16:39\r\nupdated [new]: 2020-05-05 12:13:10\r\n'),
 (110,'2020-05-05 12:13:27','::1','admin','meetings','edit','---Keys\r\nidmeetings : 5\r\n---Fields\r\nstart_date [old]: 2020-01-08 10:00:00\r\nstart_date [new]: 2020-05-08 10:00:00\r\nend_date [old]: 2020-01-08 12:00:00\r\nend_date [new]: 2020-05-08 12:00:00\r\nupdated [old]: 2020-01-07 18:16:48\r\nupdated [new]: 2020-05-05 12:13:27\r\n'),
 (111,'2020-05-05 12:13:48','::1','admin','meetings','edit','---Keys\r\nidmeetings : 3\r\n---Fields\r\nstart_date [old]: 2020-01-07 18:00:00\r\nstart_date [new]: 2020-05-07 18:00:00\r\nend_date [old]: 2020-01-07 19:00:00\r\nend_date [new]: 2020-05-07 19:00:00\r\nupdated [old]: 2020-01-07 18:10:41\r\nupdated [new]: 2020-05-05 12:13:48\r\n'),
 (112,'2020-05-05 12:14:25','::1','admin','meetings','edit','---Keys\r\nidmeetings : 6\r\n---Fields\r\nstart_date [old]: 2020-01-09 19:00:00\r\nstart_date [new]: 2020-05-11 19:00:00\r\nend_date [old]: 2020-01-09 20:00:00\r\nend_date [new]: 2020-05-11 20:00:00\r\nupdated [old]: 2020-01-09 18:17:17\r\nupdated [new]: 2020-05-05 12:14:25\r\n'),
 (113,'2020-05-05 12:27:31','::1','admin','projects','edit','---Keys\r\nproject_id : 3\r\n---Fields\r\ncolor_identifier [old]: #ABBCD6\r\ncolor_identifier [new]: #9C3DDB\r\nupdated [old]: 2019-11-18 14:15:41\r\nupdated [new]: 2020-05-05 12:27:31\r\n'),
 (114,'2020-05-05 12:27:53','::1','admin','projects','edit','---Keys\r\nproject_id : 3\r\n---Fields\r\ncolor_identifier [old]: #9C3DDB\r\ncolor_identifier [new]: #ED691D\r\nupdated [old]: 2020-05-05 12:27:31\r\nupdated [new]: 2020-05-05 12:27:53\r\n');
/*!40000 ALTER TABLE `meetings_audit` ENABLE KEYS */;


--
-- Definition of table `meetings_settings`
--

DROP TABLE IF EXISTS `meetings_settings`;
CREATE TABLE `meetings_settings` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `TYPE` int(11) DEFAULT '1',
  `NAME` mediumtext,
  `USERNAME` mediumtext,
  `COOKIE` varchar(500) DEFAULT NULL,
  `SEARCH` mediumtext,
  `TABLENAME` varchar(300) DEFAULT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `meetings_settings`
--

/*!40000 ALTER TABLE `meetings_settings` DISABLE KEYS */;
INSERT INTO `meetings_settings` (`ID`,`TYPE`,`NAME`,`USERNAME`,`COOKIE`,`SEARCH`,`TABLENAME`) VALUES 
 (1,2,NULL,'admin',NULL,'{\"gridWidth\":929.4,\"thWidths\":{\"grid_headcell_icons\":27.4,\"grid_headcell_checkbox\":117.4,\"grid_headcell_details\":93.4,\"grid_headcell_field\":61.4,\"grid_headcell_field1\":104.4,\"grid_headcell_field2\":168.4,\"grid_headcell_field3\":68.4,\"grid_headcell_field4\":99.4,\"grid_headcell_field5\":104.4}}','meetings'),
 (2,2,NULL,'admin',NULL,'{\"gridWidth\":685.4,\"thWidths\":{\"grid_headcell_icons\":48.4,\"grid_headcell_checkbox\":25.4,\"grid_headcell_details\":71.4,\"grid_headcell_field\":21.4,\"grid_headcell_field1\":184.4,\"grid_headcell_field2\":277.4}}','super_catalog'),
 (3,2,NULL,'admin',NULL,'{\"gridWidth\":422,\"thWidths\":{\"grid_headcell_field\":10,\"grid_headcell_field1\":50,\"grid_headcell_field2\":130,\"grid_headcell_field3\":56,\"grid_headcell_field4\":66,\"grid_headcell_field5\":61}}','users_meetings'),
 (4,2,NULL,'admin',NULL,'{\"gridWidth\":944.4,\"thWidths\":{\"grid_headcell_icons\":26.4,\"grid_headcell_checkbox\":20.4,\"grid_headcell_field\":9.4,\"grid_headcell_field1\":135.4,\"grid_headcell_field2\":440.4,\"grid_headcell_field3\":92.4,\"grid_headcell_field4\":154.4}}','config'),
 (5,2,NULL,'admin',NULL,'{\"gridWidth\":830.4,\"thWidths\":{\"grid_headcell_icons\":34.4,\"grid_headcell_checkbox\":82.4,\"grid_headcell_details\":43.4,\"grid_headcell_field\":14.4,\"grid_headcell_field1\":76.4,\"grid_headcell_field2\":93.4,\"grid_headcell_field3\":72.4,\"grid_headcell_field4\":60.4,\"grid_headcell_field5\":107.4,\"grid_headcell_field6\":71.4,\"grid_headcell_field7\":70.4}}','projects'),
 (6,2,NULL,'admin',NULL,'{\"gridWidth\":843.4,\"thWidths\":{\"grid_headcell_icons\":26.4,\"grid_headcell_checkbox\":88.4,\"grid_headcell_details\":33.4,\"grid_headcell_field\":34.4,\"grid_headcell_field1\":125.4,\"grid_headcell_field2\":118.4,\"grid_headcell_field3\":49.4,\"grid_headcell_field4\":64.4,\"grid_headcell_field5\":100.4,\"grid_headcell_field6\":108.4}}','departments'),
 (7,2,NULL,'admin',NULL,'{\"gridWidth\":825.4,\"thWidths\":{\"grid_headcell_icons\":26.4,\"grid_headcell_checkbox\":80.4,\"grid_headcell_details\":33.4,\"grid_headcell_field\":9.4,\"grid_headcell_field1\":164.4,\"grid_headcell_field2\":49.4,\"grid_headcell_field6\":86.4,\"grid_headcell_field11\":221.4,\"grid_headcell_field12\":67.4}}','companies'),
 (8,2,NULL,'admin',NULL,'{\"gridWidth\":939.4,\"thWidths\":{\"grid_headcell_icons\":26.4,\"grid_headcell_checkbox\":88.4,\"grid_headcell_details\":33.4,\"grid_headcell_field\":9.4,\"grid_headcell_field1\":67.4,\"grid_headcell_field2\":139.4,\"grid_headcell_field3\":128.4,\"grid_headcell_field4\":242.4,\"grid_headcell_field5\":119.4}}','users');
/*!40000 ALTER TABLE `meetings_settings` ENABLE KEYS */;


--
-- Definition of table `meetings_uggroups`
--

DROP TABLE IF EXISTS `meetings_uggroups`;
CREATE TABLE `meetings_uggroups` (
  `GroupID` int(11) NOT NULL AUTO_INCREMENT,
  `Label` varchar(300) DEFAULT NULL,
  PRIMARY KEY (`GroupID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `meetings_uggroups`
--

/*!40000 ALTER TABLE `meetings_uggroups` DISABLE KEYS */;
/*!40000 ALTER TABLE `meetings_uggroups` ENABLE KEYS */;


--
-- Definition of table `meetings_ugmembers`
--

DROP TABLE IF EXISTS `meetings_ugmembers`;
CREATE TABLE `meetings_ugmembers` (
  `UserName` varchar(300) NOT NULL,
  `GroupID` int(11) NOT NULL,
  PRIMARY KEY (`UserName`(50),`GroupID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `meetings_ugmembers`
--

/*!40000 ALTER TABLE `meetings_ugmembers` DISABLE KEYS */;
INSERT INTO `meetings_ugmembers` (`UserName`,`GroupID`) VALUES 
 ('admin',-1);
/*!40000 ALTER TABLE `meetings_ugmembers` ENABLE KEYS */;


--
-- Definition of table `meetings_ugrights`
--

DROP TABLE IF EXISTS `meetings_ugrights`;
CREATE TABLE `meetings_ugrights` (
  `TableName` varchar(300) NOT NULL,
  `GroupID` int(11) NOT NULL,
  `AccessMask` varchar(10) DEFAULT NULL,
  `Page` mediumtext,
  PRIMARY KEY (`TableName`(50),`GroupID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `meetings_ugrights`
--

/*!40000 ALTER TABLE `meetings_ugrights` DISABLE KEYS */;
INSERT INTO `meetings_ugrights` (`TableName`,`GroupID`,`AccessMask`,`Page`) VALUES 
 ('calendar',-1,'AESPI',NULL),
 ('catalog',-1,'ADESPIM',NULL),
 ('companies',-1,'ADESPIM',NULL),
 ('config',-1,'ADESPIM',NULL),
 ('departments',-1,'ADESPIM',NULL),
 ('files_meetings',-1,'AEDSPI',NULL),
 ('lv_catalog',-1,'ADESPIM',NULL),
 ('meetings',-1,'AEDSPI',NULL),
 ('projects',-1,'ADESPIM',NULL),
 ('super_catalog',-1,'ADESPIM',NULL),
 ('users',-1,'ADESPIM',NULL),
 ('users_meetings',-1,'AEDSPI',NULL);
/*!40000 ALTER TABLE `meetings_ugrights` ENABLE KEYS */;


--
-- Definition of table `projects`
--

DROP TABLE IF EXISTS `projects`;
CREATE TABLE `projects` (
  `project_id` int(10) NOT NULL AUTO_INCREMENT,
  `companies_company_id` int(10) NOT NULL,
  `departments_dept_id` int(10) unsigned DEFAULT NULL,
  `short_name` varchar(10) COLLATE utf8_unicode_ci NOT NULL,
  `name` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `owner` int(10) NOT NULL DEFAULT '0',
  `start_date` date DEFAULT NULL,
  `end_date` date DEFAULT NULL,
  `status` int(10) DEFAULT '0',
  `color_identifier` varchar(7) COLLATE utf8_unicode_ci DEFAULT '#FFFFFF',
  `description` mediumtext COLLATE utf8_unicode_ci,
  `worked_hours` float NOT NULL DEFAULT '0',
  `creator` int(10) DEFAULT '0',
  `active` int(1) NOT NULL DEFAULT '1',
  `project_updator` int(10) NOT NULL DEFAULT '0',
  `created` datetime NOT NULL DEFAULT '1000-01-01 00:00:00',
  `updated` datetime NOT NULL DEFAULT '1000-01-01 00:00:00',
  `status_comment` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`project_id`),
  KEY `idx_project_owner` (`owner`),
  KEY `project_name` (`name`),
  KEY `project_short_name` (`short_name`),
  KEY `project_start_date` (`start_date`),
  KEY `project_end_date` (`end_date`),
  KEY `project_status` (`status`),
  KEY `project_creator` (`creator`),
  KEY `fk_projects_companies_idx` (`companies_company_id`),
  KEY `fk_projects_departments1_idx` (`departments_dept_id`),
  CONSTRAINT `fk_projects_companies` FOREIGN KEY (`companies_company_id`) REFERENCES `companies` (`company_id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_projects_departments1` FOREIGN KEY (`departments_dept_id`) REFERENCES `departments` (`dept_id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `projects`
--

/*!40000 ALTER TABLE `projects` DISABLE KEYS */;
INSERT INTO `projects` (`project_id`,`companies_company_id`,`departments_dept_id`,`short_name`,`name`,`owner`,`start_date`,`end_date`,`status`,`color_identifier`,`description`,`worked_hours`,`creator`,`active`,`project_updator`,`created`,`updated`,`status_comment`) VALUES 
 (2,3,1,'P19/001','Proyecto 1',6,'2019-11-13',NULL,1,'#AF2DCC','Descripción del proyecto',0,6,1,6,'2019-11-13 16:30:05','2020-01-07 17:12:05',''),
 (3,3,1,'P19/002','Proyecto 2',6,'2019-11-18',NULL,1,'#ED691D','',0,6,1,6,'2019-11-18 14:15:41','2020-05-05 12:27:53','');
/*!40000 ALTER TABLE `projects` ENABLE KEYS */;


--
-- Definition of table `super_catalog`
--

DROP TABLE IF EXISTS `super_catalog`;
CREATE TABLE `super_catalog` (
  `idsuper_catalog` int(11) NOT NULL AUTO_INCREMENT,
  `super_code` varchar(20) COLLATE utf8_unicode_ci NOT NULL,
  `description` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`idsuper_catalog`),
  UNIQUE KEY `super_catalog_ixd1` (`super_code`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `super_catalog`
--

/*!40000 ALTER TABLE `super_catalog` DISABLE KEYS */;
INSERT INTO `super_catalog` (`idsuper_catalog`,`super_code`,`description`) VALUES 
 (1,'LANGUAGE','Idiomas de los literales'),
 (2,'COMPANY','Type of Companies'),
 (3,'DECISION','Afirmativo y negativo'),
 (4,'RELATION_USER','Situación de la relación de usuarios y reuniones'),
 (5,'STATUS_PROJ','Status of Project'),
 (7,'DURATION_TYPE','Tipo de Duración'),
 (8,'PERCENT','% PREFIJADOS'),
 (9,'ACEPTATION_USER','Aceptación de los Usuarios a la Reunión');
/*!40000 ALTER TABLE `super_catalog` ENABLE KEYS */;


--
-- Definition of table `users`
--

DROP TABLE IF EXISTS `users`;
CREATE TABLE `users` (
  `user_id` int(10) NOT NULL AUTO_INCREMENT,
  `login` varchar(16) COLLATE utf8_unicode_ci NOT NULL,
  `companies_company_id` int(10) NOT NULL DEFAULT '0',
  `departments_dept_id` int(10) unsigned DEFAULT NULL,
  `username` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `password` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `signature` mediumtext COLLATE utf8_unicode_ci,
  `email` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'user@domain.com',
  `reset_token` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `reset_date` datetime DEFAULT NULL,
  `color_identifier` varchar(7) COLLATE utf8_unicode_ci NOT NULL DEFAULT '#FFFFFF',
  PRIMARY KEY (`user_id`),
  KEY `user_username` (`username`),
  KEY `fk_users_companies1_idx` (`companies_company_id`),
  KEY `user_login` (`login`),
  CONSTRAINT `fk_users_companies1` FOREIGN KEY (`companies_company_id`) REFERENCES `companies` (`company_id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `users`
--

/*!40000 ALTER TABLE `users` DISABLE KEYS */;
INSERT INTO `users` (`user_id`,`login`,`companies_company_id`,`departments_dept_id`,`username`,`password`,`signature`,`email`,`reset_token`,`reset_date`,`color_identifier`) VALUES 
 (6,'admin',0,NULL,'Fernando Humanes','21232f297a57a5a743894a0e4a801fc3','','info@fhumanes.com',NULL,NULL,'#F70D0D'),
 (7,'user1',3,1,'Usuario 1','24c9e15e52afc47c225b757e7bee1f9d',NULL,'user1@fhumanes.com',NULL,NULL,'#7468F7'),
 (8,'user2',3,NULL,'Usuario 2','7e58d63b60197ceb55a1c487989a3720',NULL,'user2@fhumanes.com',NULL,NULL,'#2FF01D');
/*!40000 ALTER TABLE `users` ENABLE KEYS */;


--
-- Definition of table `users_meetings`
--

DROP TABLE IF EXISTS `users_meetings`;
CREATE TABLE `users_meetings` (
  `idusers_meetings` int(11) NOT NULL AUTO_INCREMENT,
  `meetings_idmeetings` int(11) NOT NULL,
  `users_user_id` int(10) NOT NULL,
  `relation_num` int(11) NOT NULL DEFAULT '0',
  `acceptation_num` int(11) NOT NULL DEFAULT '0',
  `commentary` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`idusers_meetings`),
  KEY `fk_users_meetings_meetings1_idx` (`meetings_idmeetings`),
  KEY `fk_users_meetings_users1_idx` (`users_user_id`),
  CONSTRAINT `fk_users_meetings_meetings1` FOREIGN KEY (`meetings_idmeetings`) REFERENCES `meetings` (`idmeetings`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_users_meetings_users1` FOREIGN KEY (`users_user_id`) REFERENCES `users` (`user_id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `users_meetings`
--

/*!40000 ALTER TABLE `users_meetings` DISABLE KEYS */;
INSERT INTO `users_meetings` (`idusers_meetings`,`meetings_idmeetings`,`users_user_id`,`relation_num`,`acceptation_num`,`commentary`) VALUES 
 (1,1,7,1,0,'Coment'),
 (2,2,7,1,0,''),
 (3,1,6,2,0,''),
 (4,1,8,1,0,'');
/*!40000 ALTER TABLE `users_meetings` ENABLE KEYS */;




/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
